/***************************************************************************
*                        Huffman Library Header File
*
*   File    : huffman.h
*   Purpose : Provide header file for programs linking to Huffman library
*             functions.
*   Author  : Michael Dipperstein
*   Date    : February 25, 2004
*
****************************************************************************
*
* Huffman: An ANSI C Huffman Encoding/Decoding Routine
* Copyright (C) 2004, 2007, 2014 by
* Michael Dipperstein (mdipper@alumni.engr.ucsb.edu)
*
* This file is part of the Huffman library.
*
* The Huffman library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 3 of the
* License, or (at your option) any later version.
*
* The Huffman library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
* General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
***************************************************************************/

#ifndef _HUFFMAN_H_
#define _HUFFMAN_H_

#include "bitfile.h"
#include "huflocal.h"
/***************************************************************************
*                                CONSTANTS
***************************************************************************/

/***************************************************************************
*                               PROTOTYPES
***************************************************************************/

/* traditional codes */
/*int HuffmanEncodeFile(FILE *inFile, FILE *outFile);      */
int HuffmanEncodeFileBX(FILE *inFile, FILE *outFile, int **BX);     /* encode file */
/*int HuffmanDecodeFile(FILE *inFile, FILE *outFile);      */
int HuffmanDecodeToBytes(FILE *inFile, bit_file_t **bInFile, huffman_node_t **ht);     /* decode file */
int HuffmanDecodePartition(unsigned char **outb, int inicio, int fin, int *numelems, huffman_node_t *ht, bit_file_t *bin);
int HuffmanBitFileRef(bit_file_t **copy, bit_file_t *in);
void huffmanclean(huffman_node_t *h, bit_file_t *bb);
void cleanall(FILE *in, bit_file_t *b, huffman_node_t *ht);

#endif /* _HUFFMAN_H_ */
