#include <set>
#include <map>
#include <unordered_map>
#include <string>
#include "sys/times.h"
#include <chrono>
#include <vector>
#include <array>
#include <algorithm>
#include <omp.h>
#include <bitset>
#include <stdlib.h>

#include <sdsl/int_vector.hpp>
#include <sdsl/bit_vectors.hpp>
#include <sdsl/util.hpp>
#include <sdsl/rank_support.hpp>
#include <sdsl/select_support.hpp>
#include <sdsl/suffix_arrays.hpp>

  struct myCompare{
    bool operator()(std::pair<uint32_t, uint32_t> elem1 ,std::pair<uint32_t, uint32_t> elem2){
      return (elem1.second < elem2.second);         
    }
  };

extern "C" {
        #include "huffman.h"
}

huffman_node_t *readCompressedHuffB2(const std::string path, bit_file_t **bInFile){
    const std::string b2Path = path + ".B2.bin.huffman";

    FILE *inFile = NULL;

    if ((inFile = fopen(b2Path.c_str(), "rb")) == NULL){
        std::cout<<" cannot read B2 huffman file\n";
        exit(1);
    }

    huffman_node_t *ht = NULL;

    HuffmanDecodeToBytes(inFile, bInFile, &ht);

    if(ht == NULL || bInFile == NULL){
            std::cout<<" ht is NULL o bb es NULL\n";
            exit(1);
    }

    return ht;
}

void readCompressed(const std::string path, sdsl::wm_int<sdsl::rrr_vector<15>> &x_wm,
    sdsl::rrr_vector<63> &b1_rrr,
    sdsl::wm_int<sdsl::rrr_vector<15>> &y_wm)
{
    // Path to sequences
    const std::string xPath = path + ".X.bin-wm_int.sdsl";
    const std::string b1Path = path + ".B1-rrr-64.sdsl";
    const std::string yPath = path + ".Y.bin.huff.bin-wm_int.sdsl";

    // Read compressed files
    load_from_file(x_wm, xPath.c_str());
    load_from_file(b1_rrr, b1Path.c_str());
    load_from_file(y_wm, yPath.c_str());

    return;
}

void getCliques(sdsl::wm_int<sdsl::rrr_vector<15>> &x_wm,
    sdsl::rrr_vector<63>::rank_1_type &b1_rank, sdsl::rrr_vector<63>::select_1_type &b1_select,
    huffman_node_t *ht, bit_file_t *bInFile,
    sdsl::wm_int<sdsl::rrr_vector<15>> &yRAM, uint32_t ylen, uint32_t nthreads)
{
    // get neighbors by each partition
    uint32_t b1size = b1_rank.size();
    uint32_t ps = b1_rank(b1size) - 1;
    std::cerr<<" Total Partitions "<<ps<<" ylen "<<ylen<<"\n";

  #pragma omp parallel num_threads(nthreads)
  {
    #pragma omp for schedule(guided) nowait
    for (uint64_t partitionNumber = 1; partitionNumber < ylen; ++partitionNumber)
    {
        uint32_t tid = omp_get_thread_num();
        uint64_t partitionIndex = b1_select(partitionNumber);
        const uint64_t nextPartitionIndex = b1_select(partitionNumber + 1);
        uint32_t current_Y = yRAM[partitionNumber-1];
        uint32_t nextp_Y = yRAM[partitionNumber];

        const uint32_t psize = nextPartitionIndex - partitionIndex;
        std::vector<uint64_t> xRAM(psize);
        #pragma omp simd
        for(uint64_t i = 0; i < psize; ++i)
        {
            xRAM[i] = x_wm[i+partitionIndex];
        }
        int numb2 = 0;

        std::vector<unsigned char> b2RAM(nextp_Y-current_Y);
        unsigned char *ptr = b2RAM.data();
        huffman_node_t *htT = ht;
        bit_file_t *bInFileT;
        HuffmanBitFileRef(&bInFileT, bInFile);
        if(bInFileT == NULL){
                std::cout<<"ERROR bInFileT is null\n";
        }

        int ret = HuffmanDecodePartition(&ptr, current_Y, nextp_Y, &numb2, htT, bInFileT);
        uint32_t bytesPerNode = numb2/psize;

	uint32_t numberBits = bytesPerNode*8;
        std::vector< std::vector<uint32_t> > clparts(numberBits);// each bit for each diff clique 

        // each node in partition has bytesPerNode associated to store to which clique belongs
        for(uint32_t xI1 = partitionIndex; xI1 < nextPartitionIndex; xI1++)
        {
              const uint64_t currentByteIndex = bytesPerNode * (xI1 - partitionIndex);
              const uint64_t current_node = xRAM[xI1-partitionIndex];
              uint32_t currentBit = 0;
              for(uint64_t bytesChecked = 0; bytesChecked<bytesPerNode; ++bytesChecked){
                        const uint8_t maskByteOfCurrent = (uint8_t)b2RAM[currentByteIndex + bytesChecked];
                        std::bitset<8> b2_cur(maskByteOfCurrent);
                        //std::cout<<" b2_cur "<<b2_cur<<"\n";
                        for(uint32_t xx=0; xx<8; xx++){
                                if(b2_cur.test(xx)){
                                        //std::cout<<"currentBit "<<currentBit<<" node "<<current_node<<"\n";
                                        clparts[currentBit].emplace_back(current_node);
                                }
                                currentBit++;
                        }
              }
         }
         std::map< std::set<uint32_t>, uint32_t> localTs;
         uint32_t u,v,w,gl=0;
         for(uint32_t a=0; a<numberBits; a++){
                uint32_t clisize = clparts[a].size();
		#pragma omp critical
                if(clisize > 1){
                        for(uint32_t r=0; r<clisize; r++){
                                std::cout<<clparts[a][r]<<" ";
                        }
                        std::cout<<"\n";
                }
         }
     }

     #pragma omp for schedule(guided) nowait
     for (uint64_t partitionNumber = ylen; partitionNumber <= ps; ++partitionNumber)
     {
        uint64_t partitionIndex = b1_select(partitionNumber);
        const uint64_t nextPartitionIndex = b1_select(partitionNumber + 1);
       
        const uint32_t psize = nextPartitionIndex - partitionIndex;

        #pragma omp critical 
        {
           for(uint64_t i = 0; i < psize; ++i) {
            std::cout<<x_wm[i+partitionIndex]<<" ";
           }
	   std::cout<<"\n";	
	}

     }

  }
}



int main(int argc, char const *argv[])
{
    if(2 > argc)
    {
        std::cerr << "Modo de uso: " << argv[0] << " RUTA_BASE nthreads " << std::endl;
        return -1;
    }

    const std::string path(argv[1]);
    uint32_t nthreads = atoi(argv[2]);


    // Variables to read compressed sequences
    sdsl::wm_int<sdsl::rrr_vector<15>> x_wm;
    sdsl::rrr_vector<63> b1_rrr;
    sdsl::wm_int<sdsl::rrr_vector<15>> y_wm;

    bit_file_t *bInFile = NULL;
    huffman_node_t *ht = readCompressedHuffB2(path, &bInFile); 
    readCompressed(path, x_wm, b1_rrr, y_wm);
    sdsl::rrr_vector<63>::rank_1_type b1r(&b1_rrr);
    sdsl::rrr_vector<63>::select_1_type b1s(&b1_rrr);
    uint32_t ylen = y_wm.size();

    std::chrono::high_resolution_clock::time_point start_time = std::chrono::high_resolution_clock::now();

    getCliques(x_wm, b1r, b1s, ht, bInFile, y_wm, ylen, nthreads);

    std::chrono::high_resolution_clock::time_point stop_time = std::chrono::high_resolution_clock::now();

    auto duration = std::chrono::duration_cast<std::chrono::milliseconds> (stop_time - start_time).count();

    std::cerr << "Time cliques : " << duration << " [ms]" << std::endl;

    return 0;
}
